(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     27686,        776]
NotebookOptionsPosition[     25702,        713]
NotebookOutlinePosition[     26191,        731]
CellTagsIndexPosition[     26148,        728]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Schmidt-Cassegrain Telescope with a corrector in front of the Cassegrain \
combination\
\>", "Title",
 CellChangeTimes->{{3.6776052616935387`*^9, 3.6776052642446847`*^9}, 
   3.677609637065796*^9, {3.677653964221164*^9, 3.677653965231222*^9}, {
   3.677850306423555*^9, 3.6778503434936066`*^9}}],

Cell[CellGroupData[{

Cell["Main function", "Subsection"],

Cell[TextData[StyleBox["SchmidtCassegrainCBefore",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["f1",
           FontWeight->Bold], Cell["focal length of the primary mirror"]},
         {Cell["ft",
           FontWeight->Bold], Cell["total focal length"]},
         {Cell["em",
           FontWeight->Bold], Cell["back distance"]},
         {Cell["Ni",
           FontWeight->Bold], Cell["refractive index of the lens"]},
         {Cell["thick",
           FontWeight->Bold], Cell["thickness of the corrector"]},
         {Cell["\[Delta]",
           FontWeight->Bold], Cell[
          "fraction of distance corrector-primary in focal unity"]},
         {Cell["diam",
           FontWeight->Bold], Cell["diameter of the primary mirror"]},
         {Cell["\[Theta]",
           FontWeight->Bold], Cell["field angle in degrees"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interface function", "Subsection"],

Cell[TextData[{
 StyleBox["SchmidtCassegrainCBeforeInputPanel",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 " (no argument required, it creates a panel to work with the main function \
by means of easy controls and input fields)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary function", "Subsection"],

Cell[TextData[StyleBox["TotalAberrations",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["rad",
           FontWeight->Bold], Cell["list of the radii of the surfaces"]},
         {Cell["thick",
           FontWeight->Bold], Cell["\<\
list of the distances between the surfaces along the optical axis\
\>"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["costasf",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"list of the constants which characterize the nature of any \
surface\"\>"},
             {"\<\"(0 for a sphere, K for a conic, {a4, as} for an aspheric \
surface)\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["stoprad",
           FontWeight->Bold], Cell["radius of the aperture stop"]},
         {Cell["nstop",
           FontWeight->Bold], Cell["number of the surfaces before the stop"]},
         {Cell["dis",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"if nstop = 0, is the (negative) distance of the aperture \
stop from the first surface after it\"\>"},
             {"\<\"if nstop > 0,  is the distance between the last surface \
before the aperture stop and the aperture stop\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["dobject",
           FontWeight->Bold], Cell[
          "distance of the object from the first surface"]},
         {Cell["hobject",
           FontWeight->Bold], Cell["\<\
height of the object (only if the object is at a finite distance)\
\>"]},
         {Cell["angle",
           FontWeight->Bold], Cell[
          "view angle in degrees (if the object is at infinity)"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]},
         {"\[SpanFromAbove]", Cell["Coefficients"], Cell[
          "gives only aberration coefficients"]},
         {"\[SpanFromAbove]", Cell["None"], Cell["doesn't show any result"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Output variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["GOn",
           FontWeight->Bold], Cell["Number of surface"]},
         {Cell["GOren",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the entrance pupil for \"",SubscriptBox[
            "\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOwen",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOrexit",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the exit pupil for \"",SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOdistancefp",
           FontWeight->Bold], Cell[
          "Distance of the first principal plane from the first surface"]},
         {Cell["GOdistancesp",
           FontWeight->Bold], Cell[
          "Distance of the second principal plane from the last surface"]},
         {Cell["GOdistancegauss",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOfocalLength",
           FontWeight->Bold], Cell["Focal length"]},
         {Cell["GOimageHeight",
           FontWeight->Bold], Cell["Image height"]},
         {Cell["GOaberration",
           FontWeight->Bold], Cell["Third-order spherical aberration "]},
         {Cell["GOcoma",
           FontWeight->Bold], Cell["Third-order coma"]},
         {Cell["GOastigmatism",
           FontWeight->Bold], Cell["Third-order astigmatism"]},
         {Cell["GOcurvature",
           FontWeight->Bold], Cell["Third-order total curvature"]},
         {Cell["GOSeidelCurvature",
           FontWeight->Bold], Cell["Third-order curvature coefficient"]},
         {Cell["GOPetzvalRadius",
           FontWeight->Bold], Cell["Petzval radius"]},
         {Cell["GOdistortion",
           FontWeight->Bold], Cell["Third-order distortion"]},
         {Cell["GOSphericalCoefficient",
           FontWeight->Bold], Cell["Spherical Coefficient"]},
         {Cell["GOComaCoefficient",
           FontWeight->Bold], Cell["Coma Coefficient"]},
         {Cell["GOAstigmatismCoefficient",
           FontWeight->Bold], Cell["Astigmatism Coefficient"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Schmidt-Cassegrain telescope with a corrector in front of the Cassegrain \
combination\
\>", "Title",
 CellChangeTimes->{
  3.677609660345127*^9, {3.677653976177848*^9, 3.6776539769898944`*^9}, 
   3.677850350753617*^9}],

Cell["\<\
The Schmidt-Cassegrain telescope is formed by a Schmidt corrector placed in \
front of a Cassegrain combination. With this optical scheme it is possible to \
eliminate spherical aberration, coma, and astigmatism. The cromatism is \
negligible.
The designe starts with the paraxial data of the Cassegrain combination:\
\>", "Text",
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f1", " ", "=", " ", 
    RowBox[{"primary", " ", "focal", " ", "lenght"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"ft", " ", "=", " ", 
   RowBox[{"total", " ", "focal", " ", "length"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", " ", "=", 
   RowBox[{"back", " ", "distance"}]}], ";"}]}], "DisplayFormula",
 CellChangeTimes->{{3.6776050610800643`*^9, 3.6776050866755285`*^9}, {
  3.6776051257557635`*^9, 3.677605148847084*^9}}],

Cell["and it supplies the following quantities:", "Text",
 CellChangeTimes->{3.6776051524092884`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Alpha]", "=", 
   RowBox[{"em", "/", "f1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"M", "=", 
   RowBox[{"ft", "/", "f1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Beta]", "=", 
   FractionBox[
    RowBox[{"M", "-", "\[Alpha]"}], 
    RowBox[{"M", "+", "1"}]]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"co", "=", 
   RowBox[{"1", "-", "\[Beta]"}]}], ";"}], "\n", 
 RowBox[{"\[Gamma]", "=", 
  FractionBox[
   RowBox[{"2", " ", "M", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], 
   RowBox[{"1", "-", 
    SuperscriptBox["M", "2"]}]]}]}], "DisplayFormula",
 CellChangeTimes->{{3.6776050610800643`*^9, 3.6776050866755285`*^9}, {
  3.6776051257557635`*^9, 3.677605148847084*^9}}],

Cell["\<\
Then, \[Alpha] and M are taken as the fundamental variables and the following \
quantities are introduced\
\>", "Text",
 CellChangeTimes->{
  3.6776050900877237`*^9, {3.677605204801285*^9, 3.6776052070294123`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"R1", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "f1"}], " ", "=", " ", 
    RowBox[{"primary", " ", "radius"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"R2", " ", "=", " ", 
   RowBox[{
    RowBox[{"\[Gamma]", " ", "f1"}], " ", "=", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "M", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], 
       RowBox[{"1", "-", 
        SuperscriptBox["M", "2"]}]], "f1"}], "=", " ", 
     RowBox[{"secondary", " ", "radius", " ", 
      RowBox[{"(", 
       RowBox[{"\[Gamma]", "<", "0"}], ")"}]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"s12", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Beta]"}], " ", "f1"}], " ", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"M", "-", "\[Alpha]"}], 
        RowBox[{"M", "+", "1"}]]}], "f1"}], "=", " ", 
     RowBox[{
     "distance", " ", "of", " ", "the", " ", "secondary", " ", "from", " ", 
      "primary", " ", 
      RowBox[{"(", 
       RowBox[{"\[Beta]", ">", "0"}], ")"}]}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"K1", " ", "=", " ", 
   RowBox[{"conic", " ", "constant", " ", "of", " ", "primary"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"K2", "=", 
  RowBox[{"conic", " ", "constant", " ", "of", " ", 
   RowBox[{"secondary", "."}]}]}]}], "DisplayFormula",
 CellChangeTimes->{{3.6776050610800643`*^9, 3.6776051129340305`*^9}, {
  3.6776052238133726`*^9, 3.677605224144391*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["SchmidtCassegrainCBefore examples", "Title",
 CellChangeTimes->{{3.6776096711537457`*^9, 3.6776096768850737`*^9}, {
  3.6776539835812716`*^9, 3.677653984841344*^9}}],

Cell["\<\
To use the SchmidtCassegrainCBefore function you can either use directly the \
function SchmidtCassegrainCBefore[ft, f1, em, diam, Ni, \[Delta], thick, \
\[Theta]] or use the interactive panel created by calling the function \
SchmidtCassegrainCBeforeInputPanel[]. It let\[CloseCurlyQuote]s you to set \
input values and then call the SchmidtCassegrainCBefore function. Moreover, \
it helps to load examples from the saved archives and set the output style.
Here are some examples\
\>", "Text"],

Cell["Primary  F/2 - Total  focal = 2000.", "Text",
 CellChangeTimes->{{3.426314339421875*^9, 3.4263143734375*^9}, {
   3.42631442215625*^9, 3.42631447753125*^9}, 3.426314562015625*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Primary", " ", "mirror", " ", "200"}], "-", 
    RowBox[{"F", "/", "2"}], "-", " ", "Celestron"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"ft", "=", "2200."}], ";"}], "\n", 
   RowBox[{
    RowBox[{"f1", "=", "408.73"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"em", "=", "200"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"diam", "=", "200"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Ni", "=", "1.518722"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"\[Delta]", "=", 
     RowBox[{"305", "/", "408.73"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"thick", "=", "4"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"\[Theta]", "=", "0.32"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.425969231546875*^9, 3.4259692381875*^9}, {
   3.42598453215625*^9, 3.425984535*^9}, {3.425985162671875*^9, 
   3.425985175171875*^9}, {3.42598530121875*^9, 3.425985305078125*^9}, {
   3.425988695578125*^9, 3.425988738609375*^9}, 3.425988777890625*^9, 
   3.4259888195625*^9, 3.6776522845110903`*^9, {3.677653589353723*^9, 
   3.677653639727604*^9}, {3.67765399194575*^9, 3.6776539929558077`*^9}, {
   3.6776541969314747`*^9, 3.677654202765808*^9}, 3.6776584773352995`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "generates", " ", "a", " ", "new", " ", "notebook", " ", 
    "with", " ", "a", " ", "report", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"SchmidtCassegrainCBefore", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "em", ",", "Ni", ",", "thick", ",", "diam", ",", 
    "\[Delta]", ",", "\[Theta]"}], "]"}]}]], "Input",
 CellChangeTimes->{3.677658536347675*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "the", 
    " ", "summary", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"SchmidtCassegrainCBefore", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "em", ",", "Ni", ",", "thick", ",", "diam", ",", 
    "\[Delta]", ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{3.6776585436700935`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "only", 
    " ", "the", " ", "output", " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"SchmidtCassegrainCBefore", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "em", ",", "Ni", ",", "thick", ",", "diam", ",", 
    "\[Delta]", ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{3.6776585479673395`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"this", " ", "gives", " ", 
     RowBox[{"input", "/", "output"}], " ", "values", " ", "as", " ", "a", 
     " ", "Return", " ", "from", " ", "the", " ", "function"}], ",", " ", 
    RowBox[{
    "with", " ", "labels", " ", "for", " ", "each", " ", "variable"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"SchmidtCassegrainCBefore", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "em", ",", "Ni", ",", "thick", ",", "diam", ",", 
    "\[Delta]", ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Basic\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Full\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{3.6776585719397106`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "this", " ", "gives", " ", "only", " ", "output", " ", "values", " ", 
     "as", " ", "a", " ", "Return", " ", "from", " ", "the", " ", 
     "function"}], ",", " ", 
    RowBox[{"with", " ", "no", " ", "labels", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"useful", " ", "for", " ", "cutting"}], "&"}], "pasting", " ",
        "operations"}], " "}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"SchmidtCassegrainCBefore", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "em", ",", "Ni", ",", "thick", ",", "diam", ",", 
    "\[Delta]", ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Values\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{3.677658581340248*^9}],

Cell["Primary  F/2.5 - Total  focal = 2000.", "Text",
 CellChangeTimes->{{3.426314339421875*^9, 3.4263143734375*^9}, {
  3.42631442215625*^9, 3.42631447753125*^9}, {3.4263145498125*^9, 
  3.4263145555*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Primary", " ", "mirror", " ", "200"}], "-", 
    RowBox[{"F", "/", "2.5"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"ft", "=", "2000."}], ";"}], "\n", 
   RowBox[{
    RowBox[{"f1", "=", "500."}], ";"}], "\n", 
   RowBox[{
    RowBox[{"em", "=", "250."}], ";"}], "\n", 
   RowBox[{
    RowBox[{"diam", "=", "200"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Ni", "=", "1.518722"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"\[Delta]", "=", 
     RowBox[{"380.", "/", "500"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"thick", "=", "5"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"\[Theta]", "=", "0.32"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.394682645859375*^9, 3.394682655328125*^9}, {
   3.425984684671875*^9, 3.42598468834375*^9}, 3.6776539984941244`*^9, 
   3.6776586135250893`*^9, {3.6776587300697556`*^9, 3.6776587418574295`*^9}}],

Cell[BoxData[
 RowBox[{"SchmidtCassegrainCBefore", "[", 
  RowBox[{
  "f1", ",", "ft", ",", "em", ",", "Ni", ",", "thick", ",", " ", "diam", ",", 
   " ", "\[Delta]", ",", "\[Theta]"}], "]"}]], "Input",
 CellChangeTimes->{{3.394682645859375*^9, 3.394682655328125*^9}, {
   3.425984684671875*^9, 3.42598468834375*^9}, 3.6776539984941244`*^9, 
   3.6776586135250893`*^9, {3.677658744095557*^9, 3.677658772428178*^9}}],

Cell["Load examples from the archive using LoadExample ", "Text"],

Cell[BoxData[
 RowBox[{"LoadExample", "[", "\"\<SchmidtCassegrainCBefore\>\"", 
  "]"}]], "Input",
 CellChangeTimes->{3.6776586309780874`*^9}],

Cell[BoxData[
 RowBox[{"SchmidtCassegrainCBefore", "[", "]"}]], "Input",
 CellChangeTimes->{3.6776586319591436`*^9}],

Cell["Use the GUI panel to have all parameters under control", "Text"],

Cell[BoxData[
 RowBox[{"SchmidtCassegrainCBeforeInputPanel", "[", "]"}]], "Input",
 CellChangeTimes->{3.6776586352473316`*^9}]
}, Open  ]]
},
WindowSize->{1904, 992},
WindowMargins->{{-8, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> True}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"GeometricOptics.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 305, 6, 71, "Title"],
Cell[CellGroupData[{
Cell[909, 32, 35, 0, 43, "Subsection"],
Cell[947, 34, 119, 2, 46, "Text"],
Cell[1069, 38, 1808, 47, 387, "Text"],
Cell[2880, 87, 2110, 53, 389, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5027, 145, 40, 0, 43, "Subsection"],
Cell[5070, 147, 260, 6, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5367, 158, 40, 0, 43, "Subsection"],
Cell[5410, 160, 111, 2, 46, "Text"],
Cell[5524, 164, 3193, 83, 551, "Text"],
Cell[8720, 249, 2296, 56, 473, "Text"],
Cell[11019, 307, 3465, 89, 849, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14533, 402, 230, 6, 71, "Title"],
Cell[14766, 410, 355, 7, 94, "Text"],
Cell[15124, 419, 479, 12, 70, "DisplayFormula"],
Cell[15606, 433, 101, 1, 46, "Text"],
Cell[15710, 436, 730, 23, 147, "DisplayFormula"],
Cell[16443, 461, 224, 5, 46, "Text"],
Cell[16670, 468, 1543, 46, 149, "DisplayFormula"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18250, 519, 171, 2, 71, "Title"],
Cell[18424, 523, 504, 8, 94, "Text"],
Cell[18931, 533, 185, 2, 46, "Text"],
Cell[19119, 537, 1218, 30, 209, "Input"],
Cell[20340, 569, 507, 12, 55, "Input"],
Cell[20850, 583, 561, 13, 55, "Input"],
Cell[21414, 598, 588, 13, 55, "Input"],
Cell[22005, 613, 738, 16, 55, "Input"],
Cell[22746, 631, 855, 20, 55, "Input"],
Cell[23604, 653, 206, 3, 46, "Text"],
Cell[23813, 658, 921, 26, 209, "Input"],
Cell[24737, 686, 415, 7, 32, "Input"],
Cell[25155, 695, 65, 0, 46, "Text"],
Cell[25223, 697, 142, 3, 32, "Input"],
Cell[25368, 702, 116, 2, 32, "Input"],
Cell[25487, 706, 70, 0, 46, "Text"],
Cell[25560, 708, 126, 2, 32, "Input"]
}, Open  ]]
}
]
*)

